const jwt = require('jsonwebtoken');

const authentication = (req, res, next) => {
  const token = req.headers['authorization'];

  if (!token) {
    return res.status(401).json({ error: 'No token provided' });
  }

  jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
    if (err) {
      return res.status(403).json({ error: 'Failed to authenticate token' });
    }
    console.log(decoded);
    
    req.user = decoded; // Attach user info to request
    next();
  });
}

module.exports = authentication;
