const mongoose = require('mongoose');

const kycReviewSchema = new mongoose.Schema({
  kycSessionId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'KycSession',
    required: true
  },
  reviewerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  reviewTime: {
    type: Date,
    default: Date.now
  },
  decision: {
    type: String,
    enum: ['approved', 'rejected', 'pending', 'requires_additional_info'],
    required: true
  },
  remarks: String,
}, {
    timestamps: true
}
);

module.exports = mongoose.model('KycReview', kycReviewSchema);
