const mongoose = require('mongoose');

const roleSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    unique: true
  },
  displayName: {
    type: String,
    required: true
  },
  description: {type: String},
  permissions: [{
    _id: false, // Disable automatic _id generation for subdocuments
    resource: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Resource',
      // required: true
    },
    actions: [{
      type: String,
      enum: ['view', 'add', 'edit', 'delete', 'update'],
    }]
  }],
  isActive: {
    type: Boolean,
    default: true
  },
  createdBy: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User'
  }
}, {
  timestamps: true,
  autoCreate: true // Automatically create the collection if it doesn't exist
});

module.exports = mongoose.model('Role', roleSchema);

//Kycsession will be visible to the admin to review the kyc mean Get all kyc's sessions
//Admin(Tenant) - role, user, customer, 
