const express = require('express');
const checkPermission = require('../middlewares/checkPermissions');
const router = express.Router();
const authentication = require('../middlewares/authMiddleware');
const CustomerController = require('../controllers/customerController');
const { validateCustomer, updateValidateCustomer } = require('../validations/customerValidation');
// GET /api/customers - Get all customers
router.get('/', authentication, checkPermission('customers', 'view'), CustomerController.getAllCustomers);

// GET /api/customers/:id - Get customer by ID
router.get('/:id', authentication, checkPermission('customers', 'view'), CustomerController.getCustomerById);

// POST /api/customers - Create new customer
router.post('/', authentication, checkPermission('customers', 'add'), validateCustomer, CustomerController.createCustomer);

// PUT /api/customers/:id - Update customer
router.put('/:id', authentication, checkPermission('customers', 'update'), updateValidateCustomer, CustomerController.updateCustomer);

// DELETE /api/customers/:id - Soft delete customer
router.delete('/:id', authentication, checkPermission('customers', 'delete'), CustomerController.deleteCustomer);

// GET /api/customers/tenant/:tenantId - Get customers by tenant
router.get('/tenant/:tenantId', authentication, checkPermission('customers', 'view'), CustomerController.getCustomersByTenant);


module.exports = router;