const express = require('express');
const router = express.Router();
const chekcPermissions = require('../middlewares/checkPermissions');
const RoleController = require('../controllers/roleController');
const { roleValidation, updateRoleValidation } = require('../validations/roleValidation');
const authentication = require('../middlewares/authMiddleware');

// POST /api/roles - Create new role
router.post('/',authentication, chekcPermissions('role', 'add'),roleValidation, RoleController.createRole);

// GET /api/roles - Get all roles
router.get('/',authentication, chekcPermissions('role', 'view'), RoleController.getAllRoles);

// GET /api/roles/:id - Get role by ID
router.get('/:id',authentication, chekcPermissions('role', 'view'), RoleController.getRoleById);

// PUT /api/roles/:id - Update role
router.put('/:id',authentication, chekcPermissions('role', 'update'), updateRoleValidation, RoleController.updateRole);

// DELETE /api/roles/:id - Soft delete role
router.delete('/:id',authentication, chekcPermissions('role', 'delete'), RoleController.deleteRole);

router.get('/resources',authentication, chekcPermissions('resource', 'view'), RoleController.getAllResources);

module.exports = router;