const express = require('express');
const checkPermission = require('../middlewares/checkPermissions');
const router = express.Router();
const UserController = require('../controllers/userController');
const authentication = require('../middlewares/authMiddleware');
const { validateUser } = require("../validations/userValidation");
// GET /api/users - Get all users (Super Admin)
router.get('/', authentication, checkPermission('user', 'view'), UserController.getAllUsers);

// GET /api/users/:id - Get user by ID
router.get('/:id', authentication, checkPermission('user', 'view'), UserController.GetUserById);

// GET /api/users/tenant/:tenantId - Get users by tenant
router.get('/tenant/:tenantId', authentication, checkPermission('user', 'view'), UserController.getUserByTenant);

// POST /api/users - Create new user (Super Admin)
router.post('/', authentication, checkPermission('user', 'add'), validateUser, UserController.createUser);

// PUT /api/users/:id - Update user
router.put('/:id', authentication, checkPermission('user', 'update'), UserController.updateUser);

// DELETE /api/users/:id - Soft delete user
router.delete('/:id', authentication, checkPermission('user', 'delete'), UserController.deleteUser);

module.exports = router;