// const Joi = require('joi');

// const tenantValidationSchema = Joi.object({
//     name: Joi.string()
//         .required()
//         .max(100)
//         .trim()
//         .messages({
//             'any.required': 'Tenant name is required.',
//             'string.empty': 'Tenant name cannot be empty.',
//             'string.max': 'Tenant name cannot exceed {#limit} characters.',
//         }),
//     code: Joi.string()
//         .required()
//         .max(50)
//         .trim()
//         .messages({
//             'any.required': 'Tenant code is required.',
//             'string.empty': 'Tenant code cannot be empty.',
//             'string.max': 'Tenant code cannot exceed {#limit} characters.',
//         }),
//     isActive: Joi.boolean() 
//         .default(true)
//         .optional()
//         .messages({
//             'boolean.base': 'isActive must be a boolean value.',
//         }),
//     createdAt: Joi.date()
//         .iso()
//         .optional(), 
// });

// const tenantValidation = (req, res, next) => {
//     const { error, value } = tenantValidationSchema.validate(req.body, {
//         abortEarly: false, // Collect all errors instead of stopping at the first
//     });
//     if (error) {
//         const errorMessages = error.details.map(err => err.message);
//         return res.status(400).json({
//             message: 'Validation failed',
//             errors: errorMessages,
//         });
//     }
//     req.body = value; // Replace the request body with the validated value
//     next(); // Proceed to the next middleware or route handler
// }


// module.exports = {
//     tenantValidation
// };

const Joi = require('joi');

const createTenantWithUserValidationSchema = Joi.object({
    // Tenant fields
    tenantName: Joi.string()
        .min(2)
        .max(100)
        .required()
        .trim()
        .messages({
            'any.required': 'Tenant name is required',
            'string.empty': 'Tenant name cannot be empty',
            'string.min': 'Tenant name must be at least 2 characters long',
            'string.max': 'Tenant name cannot exceed 100 characters'
        }),

    tenantCode: Joi.string()
        .min(2)
        .max(50)
        .required()
        .pattern(/^[A-Z0-9_-]+$/)
        .trim()
        .uppercase()
        .messages({
            'any.required': 'Tenant code is required',
            'string.empty': 'Tenant code cannot be empty',
            'string.min': 'Tenant code must be at least 2 characters long',
            'string.max': 'Tenant code cannot exceed 50 characters',
            'string.pattern.base': 'Tenant code can only contain uppercase letters, numbers, underscores, and hyphens'
        }),

    // User fields
    userName: Joi.string()
        .min(2)
        .max(100)
        .required()
        .trim()
        .messages({
            'any.required': 'User name is required',
            'string.empty': 'User name cannot be empty',
            'string.min': 'User name must be at least 2 characters long',
            'string.max': 'User name cannot exceed 100 characters'
        }),

    userEmail: Joi.string()
        .email()
        .required()
        .trim()
        .lowercase()
        .messages({
            'any.required': 'User email is required',
            'string.empty': 'User email cannot be empty',
            'string.email': 'User email must be a valid email address'
        }),

    isActive: Joi.boolean()
        .optional()
        .default(true)
        .messages({
            'boolean.base': 'isActive must be a boolean value'
        })
});

// Validation middleware
const validateTenantWithUser = (req, res, next) => {
    const { error, value } = createTenantWithUserValidationSchema.validate(req.body, {
        abortEarly: false,
        stripUnknown: true,
        convert: true
    });

    if (error) {
        const errorMessages = error.details.map(err => err.message);
        return res.status(400).json({
            message: 'Validation failed',
            errors: errorMessages,
        });
    }

    // Replace request body with validated and sanitized data
    req.body = value;
    next();
};

module.exports = {
    validateTenantWithUser
};