const Joi = require('joi');

const userValidationSchema = Joi.object({
    name: Joi.string().min(3).max(100).required()
        .trim()
        .messages({
            'string.base': 'Name must be a string',
            'string.empty': 'Name cannot be empty',
            'string.min': 'Name must be at least 3 characters long',
            'string.max': 'Name cannot exceed 100 characters'
        }),
    email: Joi.string().email().required()
        .trim()
        .lowercase()
        .messages({
            'string.base': 'Email must be a string',
            'string.email': 'Email must be a valid email address',
            'string.empty': 'Email cannot be empty'
        }),
    password: Joi.string().min(6).max(100).required()
        .trim()
        .messages({
            'string.base': 'Password must be a string',
            'string.empty': 'Password cannot be empty',
            'string.min': 'Password must be at least 6 characters long',
            'string.max': 'Password cannot exceed 100 characters'
        }),
    roleId: Joi.string().optional()
        .messages({
            'string.base': 'Role ID must be a string',
            'string.empty': 'Role ID cannot be empty'
        }),
    isActive: Joi.boolean().optional()
});

const validateUser = (userData) => {
    const { error, value } = userValidationSchema.validate(userData, {
        abortEarly: false,
    });

    if (error) {
        const errorMessages = error.details.map(err => err.message);
        return res.status(400).json({
            message: 'Validation failed',
            errors: errorMessages,
        });
    }
    req.body = value; // Replace the request body with the validated value
    next();
}
module.exports = {
    validateUser
};