import { BrowserRouter, Routes, Route } from "react-router-dom";
import AdminLayout from "./layouts/AdminLayout.jsx";
import Login from "./pages/Login/Login.jsx";
import Dashboard from "./pages/Dashboard.jsx";
import Meetings from "./pages/Meetings.jsx";
import Chats from "./pages/Chats.jsx";
import Settings from "./pages/Settings.jsx";
import PrivateRoute from "./components/PrivateRoute.jsx";
import MeetingPage from "./pages/MeetingPage.jsx";
import Roles from "./pages/roles/Roles.jsx";

function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/" element={<Login />} />
        <Route path="/admin" element={<AdminLayout />}>
          <Route path="dashboard" element={<Dashboard />} />
          <Route path="meetings" element={<Meetings />} />
          <Route path="chats" element={<Chats />} />
          <Route path="settings" element={<Settings />} />
          <Route path="roles" element={<Roles />} />
        </Route>
        <Route path="/meeting" element={<MeetingPage />} />
      </Routes>
    </BrowserRouter>
  );
}

export default App;
