import React, { useState, useEffect } from "react";
import { NavLink, useNavigate } from "react-router-dom";
import "./Sidebar.css";
import {
  LayoutDashboard,
  Video,
  MessageSquare,
  Settings,
  Shield,
  LogOut,
  ChevronLeft,
  ChevronRight,
  User,
  Bell,
  HelpCircle,
} from "lucide-react";

const Sidebar = () => {
  const navigate = useNavigate();

  const handleLogout = () => {
    localStorage.removeItem("token");
    navigate("/admin/login");
  };

  const menuItems = [
    {
      path: "/admin/dashboard",
      icon: LayoutDashboard,
      label: "Dashboard",
      badge: null,
    },
    {
      path: "/admin/meetings",
      icon: Video,
      label: "Meetings",
      badge: null,
    },
    {
      path: "/admin/chats",
      icon: MessageSquare,
      label: "Chats",
      badge: null,
    },
    {
      path: "/admin/settings",
      icon: Settings,
      label: "Settings",
      badge: null,
    },
    {
      path: "/admin/roles",
      icon: User,
      label: "Roles & Permission",
      badge: null,
    },
  ];

  return (
    <aside className={"sidebar"}>
      {/* Header */}
      <div className="sidebar-header">
        <div className="brand-container">
          <div className="brand-icon">
            <Shield size={28} />
          </div>
          <div className="brand-text">
            <h2>Admin Portal</h2>
            <span>Management Hub</span>
          </div>
        </div>
      </div>

      {/* User Profile Section */}
      <div className="user-profile">
        <div className="avatar">
          <User size={24} />
        </div>
        <div className="user-info">
          <h4>Admin User</h4>
          <span>Administrator</span>
        </div>
        <div className="profile-actions">
          <button className="profile-btn" title="Notifications">
            <Bell size={16} />
          </button>
        </div>
      </div>

      {/* Navigation Menu */}
      <nav className="sidebar-nav">
        <div className="nav-section">
          <span className="nav-label">Main</span>
          <ul className="nav-list">
            {menuItems.map((item) => {
              const IconComponent = item.icon;
              return (
                <li key={item.path} className="nav-item">
                  <NavLink
                    to={item.path}
                    className={({ isActive }) =>
                      `nav-link ${isActive ? "active" : ""}`
                    }
                    // title={isCollapsed ? item.label : ""}
                  >
                    <div className="nav-icon">
                      <IconComponent size={20} />
                    </div>
                    <span className="nav-text">{item.label}</span>
                    {item.badge && (
                      <span className="nav-badge">{item.badge}</span>
                    )}
                  </NavLink>
                </li>
              );
            })}
          </ul>
        </div>

        {/* Support Section */}
        <div className="nav-section">
          <span className="nav-label">Support</span>
          <ul className="nav-list">
            <li className="nav-item">
              <button className="nav-link support-link">
                <div className="nav-icon">
                  <HelpCircle size={20} />
                </div>
                <span className="nav-text">Help & Support</span>
              </button>
            </li>
          </ul>
        </div>
      </nav>

      {/* Footer Actions */}
      <div className="sidebar-footer">
        <button className="logout-btn" onClick={handleLogout}>
          <LogOut size={20} />
          <span>Logout</span>
        </button>
      </div>
    </aside>
  );
};

export default Sidebar;
