import { Link, Outlet } from "react-router-dom";
import "./Layout.css"; // create this CSS file to style layout

const Layout = () => {
  return (
    <div className="layout-container">
      <aside className="sidebar">
        <h2>Meeting App</h2>
        <ul>
          <li><Link to="/">Join Meeting</Link></li>
          <li><Link to="/create">Create Meeting</Link></li>
        </ul>
      </aside>

      <main className="main-content">
        <Outlet />
      </main>
    </div>
  );
};

export default Layout;
